/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.FieldSet;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.WireFormat;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapEntryLite<K, V>
extends AbstractMessageLite {
    private static final int KEY_FIELD_NUMBER = 1;
    private static final int VALUE_FIELD_NUMBER = 2;
    private final Metadata<K, V> metadata;
    private final K key;
    private final V value;
    private volatile int cachedSerializedSize = -1;

    private MapEntryLite(WireFormat.FieldType keyType, K defaultKey, WireFormat.FieldType valueType, V defaultValue) {
        this.metadata = new Metadata(this, keyType, valueType);
        this.key = defaultKey;
        this.value = defaultValue;
    }

    private MapEntryLite(Metadata<K, V> metadata, K key, V value) {
        this.metadata = metadata;
        this.key = key;
        this.value = value;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public static <K, V> MapEntryLite<K, V> newDefaultInstance(WireFormat.FieldType keyType, K defaultKey, WireFormat.FieldType valueType, V defaultValue) {
        return new MapEntryLite<K, V>(keyType, defaultKey, valueType, defaultValue);
    }

    @Override
    public void writeTo(CodedOutputStream output) throws IOException {
        this.writeField(1, this.metadata.keyType, this.key, output);
        this.writeField(2, this.metadata.valueType, this.value, output);
    }

    private void writeField(int number, WireFormat.FieldType type, Object value, CodedOutputStream output) throws IOException {
        output.writeTag(number, type.getWireType());
        FieldSet.writeElementNoTag(output, type, value);
    }

    @Override
    public int getSerializedSize() {
        if (this.cachedSerializedSize != -1) {
            return this.cachedSerializedSize;
        }
        int size = 0;
        size += this.getFieldSize(1, this.metadata.keyType, this.key);
        this.cachedSerializedSize = size += this.getFieldSize(2, this.metadata.valueType, this.value);
        return size;
    }

    private int getFieldSize(int number, WireFormat.FieldType type, Object value) {
        return CodedOutputStream.computeTagSize(number) + FieldSet.computeElementSizeNoTag(type, value);
    }

    private MapEntryLite(Metadata<K, V> metadata, CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        try {
            int tag;
            K key = metadata.defaultInstance.key;
            V value = metadata.defaultInstance.value;
            while ((tag = input.readTag()) != 0) {
                if (tag == WireFormat.makeTag(1, metadata.keyType.getWireType())) {
                    key = this.mergeField(input, extensionRegistry, metadata.keyType, key);
                    continue;
                }
                if (tag == WireFormat.makeTag(2, metadata.valueType.getWireType())) {
                    value = this.mergeField(input, extensionRegistry, metadata.valueType, value);
                    continue;
                }
                if (input.skipField(tag)) continue;
                break;
            }
            this.metadata = metadata;
            this.key = key;
            this.value = value;
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e.getMessage()).setUnfinishedMessage(this);
        }
    }

    private <T> T mergeField(CodedInputStream input, ExtensionRegistryLite extensionRegistry, WireFormat.FieldType type, T value) throws IOException {
        switch (type) {
            case MESSAGE: {
                MessageLite.Builder subBuilder = ((MessageLite)value).toBuilder();
                input.readMessage(subBuilder, extensionRegistry);
                return (T)subBuilder.buildPartial();
            }
            case ENUM: {
                return (T)Integer.valueOf(input.readEnum());
            }
            case GROUP: {
                throw new RuntimeException("Groups are not allowed in maps.");
            }
        }
        return (T)FieldSet.readPrimitiveField(input, type, true);
    }

    public Parser<MapEntryLite<K, V>> getParserForType() {
        return this.metadata.parser;
    }

    @Override
    public Builder<K, V> newBuilderForType() {
        return new Builder(this.metadata);
    }

    @Override
    public Builder<K, V> toBuilder() {
        return new Builder(this.metadata, this.key, this.value);
    }

    @Override
    public MapEntryLite<K, V> getDefaultInstanceForType() {
        return this.metadata.defaultInstance;
    }

    @Override
    public boolean isInitialized() {
        if (this.metadata.valueType.getJavaType() == WireFormat.JavaType.MESSAGE) {
            return ((MessageLite)this.value).isInitialized();
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder<K, V>
    extends AbstractMessageLite.Builder<Builder<K, V>> {
        private final Metadata<K, V> metadata;
        private K key;
        private V value;

        private Builder(Metadata<K, V> metadata) {
            this.metadata = metadata;
            this.key = metadata.defaultInstance.key;
            this.value = metadata.defaultInstance.value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public Builder<K, V> setKey(K key) {
            this.key = key;
            return this;
        }

        public Builder<K, V> setValue(V value) {
            this.value = value;
            return this;
        }

        public Builder<K, V> clearKey() {
            this.key = this.metadata.defaultInstance.key;
            return this;
        }

        public Builder<K, V> clearValue() {
            this.value = this.metadata.defaultInstance.value;
            return this;
        }

        @Override
        public Builder<K, V> clear() {
            this.key = this.metadata.defaultInstance.key;
            this.value = this.metadata.defaultInstance.value;
            return this;
        }

        @Override
        public MapEntryLite<K, V> build() {
            MessageLite result = this.buildPartial();
            if (!((MapEntryLite)result).isInitialized()) {
                throw Builder.newUninitializedMessageException(result);
            }
            return result;
        }

        @Override
        public MapEntryLite<K, V> buildPartial() {
            return new MapEntryLite(this.metadata, this.key, this.value);
        }

        @Override
        public MessageLite getDefaultInstanceForType() {
            return this.metadata.defaultInstance;
        }

        @Override
        public boolean isInitialized() {
            if (this.metadata.valueType.getJavaType() == WireFormat.JavaType.MESSAGE) {
                return ((MessageLite)this.value).isInitialized();
            }
            return true;
        }

        private Builder(Metadata<K, V> metadata, K key, V value) {
            this.metadata = metadata;
            this.key = key;
            this.value = value;
        }

        @Override
        public Builder<K, V> clone() {
            return new Builder<K, V>(this.metadata, this.key, this.value);
        }

        @Override
        public Builder<K, V> mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            MapEntryLite entry = new MapEntryLite(this.metadata, input, extensionRegistry);
            this.key = entry.key;
            this.value = entry.value;
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Metadata<K, V> {
        public final MapEntryLite<K, V> defaultInstance;
        public final WireFormat.FieldType keyType;
        public final WireFormat.FieldType valueType;
        public final Parser<MapEntryLite<K, V>> parser;

        public Metadata(MapEntryLite<K, V> defaultInstance, WireFormat.FieldType keyType, WireFormat.FieldType valueType) {
            this.defaultInstance = defaultInstance;
            this.keyType = keyType;
            this.valueType = valueType;
            final Metadata finalThis = this;
            this.parser = new AbstractParser<MapEntryLite<K, V>>(){

                @Override
                public MapEntryLite<K, V> parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                    return new MapEntryLite(finalThis, input, extensionRegistry);
                }
            };
        }
    }
}

